/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package rdc;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

import com.inet.report.*;

/**
 * This is a example class which creates a new JTable to show how to export it
 */
public class CreateTestJTableForExport {

    //Headers for the JTable
    private static final String[]   TABLEHEADERS = { "Header1", "Header2", "Header3", "Header4", "Header5", "Header6", "Header7", "Header8",
        "Header9", "Header10", "Header11", "Header12", "Header13", "Header14" };

    //Data for the JTable
    private static final String[][] TABLEDATA    = {
        { "Col1", "Col2", "Col3", "Col4", "Col5", "Col6", "Col7", "Col8", "Col9", "Col10", "Col11", "Col12", "Col13", "Col14" },
        { "Col1", "Col2", "Col3", "Col4", "Col5", "Col6", "Col7", "Col8", "Col9", "Col10", "Col11", "Col12", "Col13", "Col14" },
        { "Col1", "Col2", "Col3", "Col4", "Col5", "Col6", "Col7", "Col8", "Col9", "Col10", "Col11", "Col12", "Col13", "Col14" },
        { "Col1", "Col2", "Col3", "Col4", "Col5", "Col6", "Col7", "Col8", "Col9", "Col10", "Col11", "Col12", "Col13", "Col14" },
        { "Col1", "Col2", "Col3", "Col4", "Col5", "Col6", "Col7", "Col8", "Col9", "Col10", "Col11", "Col12", "Col13", "Col14" },
        { "Col1", "Col2", "Col3", "Col4", "Col5", "Col6", "Col7", "Col8", "Col9", "Col10", "Col11", "Col12", "Col13", "Col14" },
        { "Col1", "Col2", "Col3", "Col4", "Col5", "Col6", "Col7", "Col8", "Col9", "Col10", "Col11", "Col12", "Col13", "Col14" },
        { "Col1", "Col2", "Col3", "Col4", "Col5", "Col6", "Col7", "Col8", "Col9", "Col10", "Col11", "Col12", "Col13", "Col14" },
        { "Col1", "Col2", "Col3", "Col4", "Col5", "Col6", "Col7", "Col8", "Col9", "Col10", "Col11", "Col12", "Col13", "Col14" },
        { "Col1", "Col2", "Col3", "Col4", "Col5", "Col6", "Col7", "Col8", "Col9", "Col10", "Col11", "Col12", "Col13", "Col14" },
        { "Col1", "Col2", "Col3", "Col4", "Col5", "Col6", "Col7", "Col8", "Col9", "Col10", "Col11", "Col12", "Col13", "Col14" } };

    /**
     * Test to create a new engine
     */
    public CreateTestJTableForExport() {
        createAndFillJTable();
    }

    /**
     * Creates a test JTable, in this example we export the data from the table
     */
    private void createAndFillJTable() {
        //Create a new JFrame to show the example table
        JFrame frame = new JFrame();
        //Create a new example JTable
        JTable table = new JTable( TABLEDATA, TABLEHEADERS ) {
            @Override
            public Component prepareRenderer( TableCellRenderer r, int row, int col ) {
                Component c = super.prepareRenderer( r, row, col );
                if( col % 2 == 0 ) {
                    c.setBackground( Color.GREEN );
                } else {
                    c.setBackground( Color.LIGHT_GRAY );
                }
                return c;
            }
        };

        //Create a new JHeader to show the header values of the table
        JTableHeader header = table.getTableHeader();

        //Set the foreground and the font of this table 
        table.setForeground( Color.blue );
        table.setFont( new Font( "Arial", Font.PLAIN, 12 ) );
        table.setBackground( Color.WHITE );

        //Set the background, foreground and font of the header row
        header.setBackground( Color.ORANGE );
        header.setForeground( Color.RED );
        header.setFont( new Font( "Engravers MT", Font.PLAIN, 14 ) );

        //Create a new JButton 
        JButton button = new JButton( "Export" );
        button.addActionListener( new MyListener( table, Engine.EXPORT_PDF, false, false, true ) );

        //add the table header, the table and the button to the frame
        frame.getContentPane().add( header, BorderLayout.NORTH );
        frame.getContentPane().add( button, BorderLayout.PAGE_END );
        frame.getContentPane().add( table, BorderLayout.CENTER );
        frame.setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE ); //set the close operation for the frame, EXIT_ON_CLOSE is standard
        frame.pack();
        frame.setVisible( true );

        //copyDataToCrystalClear(table, true, true, true);	
    }

    /**
     * ActionListener for the button
     */
    class MyListener implements ActionListener {
        private JTable table;
        private boolean marginOverrun, canGrow, showHeader;
        private String  exportType;

        /**
         * The ActionListener gets the parameters which are needed to run the function
         * exportDataFromJTableToCrystalClear
         * @param table the JTable which you want to export
         * @param exportType the export type of the engine
         * @param marginOverrun if it is true the table will be cut if its to wide for one page, otherwise it will be
         * press-formed to fit.
         * @param canGrow if it is true the cells grow to multi lines when they're to small for contained text.
         * @param showHeader if it is true the table header will be shown
         */
        public MyListener( JTable table, String exportType, boolean marginOverrun, boolean canGrow, boolean showHeader ) {
            this.table = table;
            this.marginOverrun = marginOverrun;
            this.canGrow = canGrow;
            this.showHeader = showHeader;
            this.exportType = exportType;
        }

        /**
         * If the button is pressed the export function will be called
         * @param e action event
         */
        @Override
        public void actionPerformed( ActionEvent e ) {
            ExportDataFromJTable.exportDataFromJTableToCrystalClear( table, exportType, marginOverrun, canGrow, showHeader ); //Call of the core function of this example
        }
    }

    /**
     * Main method of this sample
     * @param args arguments not used
     */
    public static void main( String[] args ) {
        new CreateTestJTableForExport();
    }
}
